<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Academic;
use Illuminate\Http\Request;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Session;

class AdminAcademicsController extends Controller
{
    //Academics View
    public function AdminAcademicsView()
    {
        Session::put('admin_page', 'admin_about_view');
        $academics = Academic::find(1);
        return view('admin.academics.academics_update', compact('academics'));
    }

    //Faculties and Staff Store
    public function AdminAcademicsStore(Request $request)
    {
        $request->validate([
            'title' => 'required|max:100',
            'des' => 'required',
        ]);
        $academics = Academic::find(1);
        $academics->title = $request->title;
        $academics->des = $request->des;
        $academics->save();
        Toastr::success('Page Updated Successfully');
        return redirect()->back();
    }
}
