<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Course;
use App\Models\CoursePage;
use App\Models\CoursePart;
use App\Models\CourseSubject;
use App\Models\DepartmentDownload;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Session;
use Brian2694\Toastr\Facades\Toastr;

class AdminCourseController extends Controller
{
    //Course View
    public function AdminCourseView()
    {
        Session::put('admin_page', 'admin_course_part_view');
        $course_view = Course::latest()->get();
        return view('admin.course.course_view', compact('course_view'));
    }

    //Course Add
    public function AdminCourseStore(Request $request)
    {
        $request->validate([
            'course_name' => 'max:255|required|unique:courses,course_name',
            'affilitated_by' => 'max:500|required',
            'course_duration' => 'max:500|required',
            'start_year' => 'max:500|required|digits:4',
        ]);
        $course_store = new Course();
        $course_store->course_name = $request->course_name;
        $course_store->course_name_slug = Str::slug($request->course_name);
        $course_store->affilitated_by = $request->affilitated_by;
        $course_store->course_duration = $request->course_duration;
        $course_store->start_year = $request->start_year;
        $course_store->save();
        Toastr::success('Course Created Successfully');
        return redirect()->back();
    }

    //Course Edit
    public function AdminCourseUpdate(Request $request, $id)
    {
        $request->validate([
            'course_name' => 'max:255',
            'affilitated_by' => 'max:500|required',
            'course_duration' => 'max:500|required',
            'start_year' => 'max:500|required|digits:4',
        ]);
        $course_update = Course::find($id);
        $course_update->course_name = $request->course_name;
        $course_update->course_name_slug = Str::slug($request->course_name);
        $course_update->affilitated_by = $request->affilitated_by;
        $course_update->course_duration = $request->course_duration;
        $course_update->start_year = $request->start_year;
        $course_update->save();
        Toastr::success('Course Updated Successfully');
        return redirect()->back();
    }

    //Course Add
    public function AdminCourseDelete($id)
    {
        if (CoursePage::where('course_id', $id)->count() > 0 or CoursePart::where('course_id', $id)->count() > 0 or CourseSubject::where('course_id', $id)->count() > 0 or DepartmentDownload::where('course_id', $id)->count() > 0) {
            Toastr::warning('Course has not been delete');
            return redirect()->back();
        } else {
            $course_delete = Course::find($id);
            $course_delete->delete();
            Toastr::success('Course Deleted Successfully');
            return redirect()->back();
        }
    }
}
