<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Course;
use App\Models\DepartmentMessage;
use Illuminate\Support\Str;
use Intervention\Image\Facades\Image;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Session;

class AdminDepartmentMessageController extends Controller
{

    //Department Message View
    public function AdminDepartmentMessageView()
    {
        Session::put('admin_page', 'admin_dpt_message_view');
        $department_message = DepartmentMessage::latest()->get();
        return view('admin.departments.message_view', compact('department_message'));
    }


    //Department Message Add View
    public function AdminDepartmentMessageAddView()
    {
        Session::put('admin_page', 'admin_dpt_message_view');
        $departments = Course::latest()->get();
        return view('admin.departments.message_add', compact('departments'));
    }

    //Department Message Store
    public function AdminDepartmentMessageStore(Request $request)
    {
        $request->validate([
            'course_id' => 'max:255|required',
            'des' => 'max:1000|required',
            'dept_message' => 'required',
            'image' => 'max:900|required',
        ]);
        $department_message_add = new DepartmentMessage();
        $department_message_add->course_id = $request->course_id;
        $department_message_add->des = $request->des;
        $department_message_add->des_slug = Str::slug($request->des);
        $department_message_add->dept_message = $request->dept_message;
        if ($request->file('image')) {
            $file = $request->file('image');
            @unlink($department_message_add->image);
            $filename = date('YmsHi') . $file->getClientOriginalName();
            Image::make($file)->save('./uploads/department_images/' . $filename);
            $uploadPath = './uploads/department_images/' . $filename;
        }
        $department_message_add->image = $uploadPath;
        $department_message_add->save();
        Toastr::success('Department Message Created Successfully');
        return redirect()->back();
    }

    //Department Message edit View
    public function AdminDepartmentMessageEdit($id)
    {
        Session::put('admin_page', 'admin_dpt_message_view');
        $departments = Course::latest()->get();
        $department_message = DepartmentMessage::find($id);
        return view('admin.departments.message_edit', compact('departments', 'department_message'));
    }

    //Department Message Store
    public function AdminDepartmentMessageUpdate(Request $request, $id)
    {
        $request->validate([
            'course_id' => 'max:255|required',
            'des' => 'max:1000|required',
            'dept_message' => 'required',
            'image'=>'nullable',
        ]);
        $department_message_update = DepartmentMessage::find($id);
        $department_message_update->course_id = $request->course_id;
        $department_message_update->des = $request->des;
        $department_message_update->des_slug = Str::slug($request->des);
        $department_message_update->dept_message = $request->dept_message;
        if ($request->file('image')) {
            $file = $request->file('image');
            @unlink($department_message_update->image);
            $filename = date('YmsHi') . $file->getClientOriginalName();
            Image::make($file)->save('./uploads/department_images/' . $filename);
            $uploadPath = './uploads/department_images/' . $filename;
            $department_message_update->image = $uploadPath;
        }
        $department_message_update->save();
        Toastr::success('Department Message Updated Successfully');
        return redirect()->back();
    }

    public function AdminDepartmentMessageDelete($id)
    {
        $department_message_delete = DepartmentMessage::find($id);
        @unlink($department_message_delete->image);
        $department_message_delete->delete();
        Toastr::success('Department Message Deleted Successfully');
        return redirect()->back();
    }
}
