<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\File;
use App\Models\DownloadFile;
use App\Models\EntrancePDF;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;
use Brian2694\Toastr\Facades\Toastr;

class AdminEntrancepdfController extends Controller
{
    //Admission View
    public function AdminEntrancePdfView()
    {
        $entrance_pdf = EntrancePDF::latest()->get();
        return view('admin.admission_pdf.entrance_pdf_view', compact('entrance_pdf'));
    }
   
     //Admission Store View
     public function AdminEntrancePdfStore(Request $request)
     {
        $request->validate([
            'title' => 'max:255|required|unique:admissions,title',
        ]);
        $admission_store = new EntrancePDF();
        $admission_store->title = $request->title;
        $admission_store->title_slug = Str::slug($request->title);
        if ($request->file('file')) {
            $file = $request->file('file');
            @unlink($admission_store->file);
            $filename = date('Y-m-s-H-i-') . $file->getClientOriginalName();
        $path = $file->store('./uploads/entrance_pdf/' . $filename);
        // do something with the file, such as store it in the database
        $admission_store->pdf = $path;
        }
  
      
        $admission_store->save();
        Toastr::success('Entrance PDF Created Successfully');
        return redirect()->back();
     }


    //Admission Store View
    public function AdminEntrancePdfUpdate(Request $request, $id)
    {
        $request->validate([
            'title' => 'max:255|required|unique:admissions,title',
        ]);
        $admission_store = EntrancePDF::find($id);
        $admission_store->title = $request->title;
        $admission_store->title_slug = Str::slug($request->title);
        if ($request->file('file')) {
            $file = $request->file('file');
            @unlink($admission_store->file);
            $filename = date('Y-m-s-H-i-') . $file->getClientOriginalName();
        $path = $file->store('./uploads/entrance_pdf/' . $filename);
        // do something with the file, such as store it in the database
        $admission_store->pdf = $path;
        }
  
        $admission_store->save();
        Toastr::success('Entrance PDF Updated Successfully');
        return redirect()->back();
    }

     //Admission Store View
     public function AdminEntrancePdfDelete($id)
     {
        $admission_delete = EntrancePDF::find($id);
        $admission_delete->delete();
        Toastr::success('Entrance PDF Deleted Successfully');
        return redirect()->back();
     }
}
