<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventImage;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;
use App\Models\NewsNotice;
use Illuminate\Support\Str;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Auth;
class AdminEventsController extends Controller
{
    //News and Notice View
    public function AdminEventView(){
        $event_view = Event::latest()->get();
        return view('admin.event.event_view', compact('event_view'));
    }

    //New and Notice Add View
    public function AdminEventAdd()
    {
        Session::put('admin_page', 'admin_notice_view');
        return view('admin.event.event_add');
    }

    //News and Notice Store
    public function AdminEventStore(Request $request)
    {
        $request->validate([
            'event_title' => 'max:255|required',
            'event_date' => 'max:255|required',
            'event_time' => 'max:255|required',
            'location' => 'max:255|required',
            'image' => 'required',
        ]);

        $event_id = Event::insertGetId([
            'user_id' => Auth::id(),
            'event_title' => $request->event_title,
            'event_date' => $request->event_date,
            'event_time' => $request->event_time,
            'location' => $request->location,
            'created_at' => Carbon::now(),
        ]);
        $image = $request->file('image');
            foreach ($image as $img) {
                $make_name = hexdec(uniqid()) . '.' . $img->getClientOriginalExtension();
                Image::make($img)->save('./uploads/event_image/' . $make_name);
                $uploadPath = './uploads/event_image/' . $make_name;
                EventImage::insert([
                    'event_id' => $event_id,
                    'image' => $uploadPath,
                    'created_at' => Carbon::now(),
                ]);
            
        }
        Toastr::success('Events Add Successfully');
       
        return redirect()->back();
    }

    //News and Notice Edit View
    public function AdminEventEdit($id)
    {
        Session::put('admin_page', 'admin_notice_view');
        $event_edit = Event::find($id);
        return view('admin.event.event_edit', compact('event_edit'));
    }


    //Event Delete
    public function AdminEventDelete($id)
    {
        $event_delete = Event::find($id);
        $image = EventImage::where('event_id', $id)->delete();
        @unlink($image->image);
        $event_delete->delete();
        Toastr::success('Events Delete Successfully');
        return redirect()->back();
    }
    


    //News Notice Image Update
    public function AdminEventImageUpdate(Request $request)
    {
        $image = $request->file('image');
        foreach ($image as $id => $img) {
            $imageDel = EventImage::find($id);
            @unlink($imageDel->image);
            $make_name = hexdec(uniqid()) . '.' . $img->getClientOriginalExtension();
            Image::make($img)->save('./uploads/event_image/' . $make_name);
            $uploadPath = './uploads/event_image/' . $make_name;
            EventImage::where('id', $id)->update([
                'image' => $uploadPath,
                'created_at' => Carbon::now(),
            ]);
        }
        Toastr::success('Image Updated Successfully');
        return redirect()->back();
    }


      //News Notice Image Delete
    public function AdminEventImageDelete($id)
    {
        $old_img = EventImage::find($id);
        @unlink($old_img->image);
        EventImage::find($id)->delete();
        Toastr::success('Image Deleted Successfully');
        return redirect()->back();
    }

    //News and Notice Update
    public function AdminEventUpdate(Request $request,$id)
    {
        $request->validate([
            'event_title' => 'max:255|required',
            'event_date' => 'max:255|required',
            'event_time' => 'max:255|required',
            'location' => 'max:255|required',
            'image' => 'required',
        ]);

      Event::findOrFail($id)->update([
        'user_id' => Auth::id(),
        'event_title' => $request->event_title,
        'event_date' => $request->event_date,
        'event_time' => $request->event_time,
        'location' => $request->location,
        'created_at' => Carbon::now(),
        ]);
       
        Toastr::success('News and Notice Add Successfully');
        return redirect()->back();
    }
}
