<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\FacultiesStaff;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Brian2694\Toastr\Facades\Toastr;

class AdminFacultiesStaffController extends Controller
{
    //Faculties and Staff Update
    public function AdminFacultiesStaffUpdate()
    {
        Session::put('admin_page', 'admin_about_view');
        $staff = FacultiesStaff::find(1);
        return view('admin.staff.staff_update', compact('staff'));
    }

    //Faculties and Staff Store
    public function AdminFacultiesStaffStore(Request $request)
    {
        $request->validate([
            'title' => 'required|max:255',
            'des' => 'required',
        ]);
        $staff = FacultiesStaff::find(1);
        $staff->title = $request->title;
        $staff->des = $request->des;
        $staff->save();
        Toastr::success('Page Updated Successfully');
        return redirect()->back();
    }
}
