<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Information;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Session;
use RealRashid\SweetAlert\Facades\Alert;
use App\Models\User;
use Brian2694\Toastr\Facades\Toastr;
class AdminInformationCOntroller extends Controller
{
    //Information View
    public function AdminInformationUpdateView()
    {
        Session::put('admin_page', 'admin_static_view');
        $info = Information::latest()->get();
        return view('admin.information.information_view', compact('info'));
    }

    //Information Update
    public function AdminInformationUpdateStore(Request $request, $id)
    {
        $request->validate([
            'title'=>'required|max:255',
            'count'=>'required',
            'logo'=>'nullable',
        ]);
        $info_update = Information::find($id);
        $info_update->title = $request->title;
        $info_update->count = $request->count;
        if ($request->file('logo')) {
            $file = $request->file('logo');
            @unlink($info_update->logo);
            $filename = date('YmsHi') . $file->getClientOriginalName();
            Image::make($file)->save('./uploads/information_icon/' . $filename);
            $uploadPath = './uploads/information_icon/' . $filename;
            $info_update->logo = $uploadPath;
        }

        $info_update->save();
        Toastr::success('Information Updated Successfully');
        return redirect()->back();
    }
}
