<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Slider;
use Illuminate\Support\Str;
use Intervention\Image\Facades\Image;
use RealRashid\SweetAlert\Facades\Alert;
use App\Models\User;
use Illuminate\Support\Facades\Session;
use Brian2694\Toastr\Facades\Toastr;

class AdminSliderController extends Controller
{
    //Admin Slider Add
    public function SliderAdd()
    {
        Session::put('admin_page', 'admin_slider_view');
        return view('admin.slider.slider_add');
    }
    public function SliderStore(Request $request)
    {
        $request->validate([
            'slider_heading' => 'max:255|required',
            'slider_sub_heading' => 'max:500|required',
            'image' => 'required|mimes:jpg,png,jpeg',
        ]);

        $slider_add = new Slider();
        $slider_add->slider_heading = $request->slider_heading;
        $slider_add->slider_sub_heading = $request->slider_sub_heading;
        $slider_add->slider_heading_slug = Str::slug($request->slider_heading);
        if ($request->file('image')) {
            $file = $request->file('image');
            @unlink($slider_add->image);
            $filename = date('YmsHi') . $file->getClientOriginalName();
            Image::make($file)->save('./uploads/slider_image/' . $filename);
            $uploadPath = './uploads/slider_image/' . $filename;
        }
        $slider_add->image = $uploadPath;
        $slider_add->status = 1;
        $slider_add->save();
        Toastr::success('Slider Add Successfully');
       
        return redirect()->back();
    }

    //Admin Slider View
    public function SliderView()
    {
        Session::put('admin_page', 'admin_slider_view');
        $slider_view = Slider::latest()->get();
        return view('admin.slider.slider_view', compact('slider_view'));
    }


    //Slider Edit View 
    public function SliderEdit($id)
    {
        Session::put('admin_page', 'admin_slider_view');
        $sliderEdit = Slider::find($id);
        return view('admin.slider.slider_edit', compact('sliderEdit'));
    }

    //Slider Update  
    public function SliderUpdate(Request $request, $id)
    {
        $request->validate([
            'slider_heading' => 'max:255|required',
            'slider_sub_heading' => 'max:500|required',
            'image' => 'mimes:jpg,png,jpeg|nullable',
        ]);

        $slider_update = Slider::find($id);
        $slider_update->slider_heading = $request->slider_heading;
        $slider_update->slider_sub_heading = $request->slider_sub_heading;
        $slider_update->slider_heading_slug = Str::slug($request->slider_heading);
        if ($request->file('image')) {
            $file = $request->file('image');
            @unlink($slider_update->image);
            $filename = date('YmsHi') . $file->getClientOriginalName();
            Image::make($file)->save('./uploads/slider_image/' . $filename);
            $uploadPath = './uploads/slider_image/' . $filename;
            $slider_update->image = $uploadPath;
        }

        $slider_update->save();
        Toastr::success('Slider Updated Successfully');
        return redirect()->route('admin.slider_view');
    }


    //Article Edit Active
    public function SliderActive($id)
    {
        Slider::find($id)->update(['status' => 0]);
        Toastr::success('Slider Inactive Successfully');
        return redirect()->back();
    }

    //Article Edit Inactive
    public function SliderInactive($id)
    {
        Slider::find($id)->update(['status' => 1]);
        Toastr::success('Slider Active Successfully');
        return redirect()->back();
    }

    //Article Delete
    public function SliderDelete($id)
    {
        $sliderDelete = Slider::find($id);
        @unlink($sliderDelete->image);
        $sliderDelete->delete();
        Toastr::success('Slider Deleted Successfully');
        return redirect()->back();
    }
}
