<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Testimonial;
use Illuminate\Http\Request;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Session;
use Intervention\Image\Facades\Image;

class AdminTestimonailController extends Controller
{
     //Testimonails View
     public function AdminTestimonailView()
     {
        Session::put('admin_page', 'admin_static_view');
         $testimonial_view = Testimonial::latest()->get();
         return view('admin.Testimonial.Testimonial_view', compact('testimonial_view'));
     }
 
     //Testimonails Add
     public function AdminTestimonailStore(Request $request)
     {
         $request->validate([
             'user_name' => 'max:255|required',
             'user_type' => 'max:500|required',
             'image' => 'required',
             'message' => 'max:1000|required',
         ]);
         $testimonial_store = new Testimonial();
         $testimonial_store->user_name = $request->user_name;
         $testimonial_store->user_type = $request->user_type;
         $testimonial_store->message = $request->message;
         if ($request->file('image')) {
            $file = $request->file('image');
            @unlink($testimonial_store->image);
            $filename = date('YmsHi') . $file->getClientOriginalName();
            Image::make($file)->save('./uploads/testimonial_image/' . $filename);
            $uploadPath = './uploads/testimonial_image/' . $filename;
            $testimonial_store->image = $uploadPath;
        }
        $testimonial_store->save();
        Toastr::success('Testimonial Added Successfully');
         return redirect()->back();
     }
 
     //Testimonails Edit
     public function AdminTestimonailUpdate(Request $request, $id)
     {
        $request->validate([
            'user_name' => 'max:255|required',
            'user_type' => 'max:255|required',
            'image' => 'nullable',
            'message' => 'max:1000|required',
        ]);
        $testimonial_store = Testimonial::find($id);
        $testimonial_store->user_name = $request->user_name;
        $testimonial_store->user_type = $request->user_type;
        $testimonial_store->message = $request->message;
        if ($request->file('image')) {
           $file = $request->file('image');
           @unlink($testimonial_store->image);
           $filename = date('YmsHi') . $file->getClientOriginalName();
           Image::make($file)->save('./uploads/testimonial_image/' . $filename);
           $uploadPath = './uploads/testimonial_image/' . $filename;
           $testimonial_store->image = $uploadPath;
       }
       $testimonial_store->save();
       Toastr::success('Testimonial Updated Successfully');
        return redirect()->back();
     }
 
     //Testimonails Delete
     public function AdminTestimonailDelete($id)
     {
         $course_delete = Testimonial::find($id);
         $course_delete->delete();
         Toastr::success('Testimonial Deleted Successfully');
         return redirect()->back();
     }
 
}
