<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Auth;
use App\Models\Video;
use Illuminate\Support\Facades\Session;

class AdminVideoController extends Controller
{
    //Admin Video View
    public function AdminVideoView()
    {
        Session::put('admin_page', 'admin_gallery_view');
        $videos = Video::latest()->get();
        return view('admin.videos.video_view', compact('videos'));
    }


    //Admin Video Store
    public function AdminVideoStore(Request $request)
    {
        $request->validate([
            'video_title'=>'required|max:255',
            'link'=>'required|max:255',
        ]);
        $video_store = new Video();
        $video_store->user_id = Auth::id();
        $video_store->video_title = $request->video_title;
        $video_store->link = $request->link;
        $video_store->save();
        Toastr::success('Video Added Successfully');
        return redirect()->back();
    }

    //Admin Video Update
    public function AdminVideoEdit(Request $request, $id)
    {
        $request->validate([
            'video_title'=>'required|max:255',
            'link'=>'required|max:255',
        ]);
        $video_update = Video::find($id);
        $video_update->user_id = Auth::id();
        $video_update->video_title = $request->video_title;
        $video_update->link = $request->link;
        $video_update->save();
        Toastr::success('Video Updated Successfully');
        return redirect()->back();
    }

     //Admin Video Delete
     public function AdminVideoDelete($id)
     {
         
         $video_delete = Video::find($id);
         $video_delete->delete();
         Toastr::success('Video Deleted Successfully');
         return redirect()->back();
     }
}
