<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\Entrance;
use App\Models\EntrancePDF;
use App\Models\EntranceProcess;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class UserApplicationController extends Controller
{
    //User Application Form
    public function UserApplicationForm()
    {
        $entrance = Entrance::latest()->get();
        $info = EntranceProcess::latest()->get();
        $pdf = EntrancePDF::latest()->get();
        return view('user.application.application', compact('entrance','info','pdf'));
    }



    
     //Result Details View
     public function UserEntrancePDFView($id)
     {
         $result_details = \App\Models\EntrancePDF::find($id);
         $pdf_path = Storage::disk('local')->path($result_details->pdf);
         return response()->file($pdf_path);
     }
}
