<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\Download;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class UserDownloadController extends Controller
{
    //User Download View
    public function UserDownloadView()
    {
        $downloads = Download::where('status',1)->where('public',1)->latest()->paginate(12);
        return view('user.download.download', compact('downloads'));
    }

    //User Download View
    public function UserDownloadFileView($id)
    {
        $result_details = \App\Models\DownloadFile::find($id);
        $pdf_path = $result_details->file;
        return Storage::download($pdf_path);
    }

    public function UserDownloadFileDetailsView($id, $slug){
        $down = Download::find($id);
        $downloads = \App\Models\DownloadFile::where('download_id', $id)->get();
        return view('user.download.download_details', compact('downloads','down'));
    }


     //Result Details View
     public function UserDownloadFilePDFView($id)
     {
         $result_details = \App\Models\DownloadFile::find($id);
         $pdf_path = Storage::disk('local')->path($result_details->file);
         return response()->file($pdf_path);
     }
}
