@php
$count = \App\Models\DepartmentDownload::where('public',0)->count();
$download = \App\Models\Download::where('public',0)->count();
$notice = \App\Models\NewsNotice::where('public',0)->count();
$total = $count + $download + $notice;
@endphp
<aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
    <div class="app-brand demo">
        <a href="{{route('dashboard')}}" class="app-brand-link">
            <span class="app-brand-logo demo">
                <svg width="25" viewBox="0 0 25 42" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                    <defs>
                        <path d="M13.7918663,0.358365126 L3.39788168,7.44174259 C0.566865006,9.69408886 -0.379795268,12.4788597 0.557900856,15.7960551 C0.68998853,16.2305145 1.09562888,17.7872135 3.12357076,19.2293357 C3.8146334,19.7207684 5.32369333,20.3834223 7.65075054,21.2172976 L7.59773219,21.2525164 L2.63468769,24.5493413 C0.445452254,26.3002124 0.0884951797,28.5083815 1.56381646,31.1738486 C2.83770406,32.8170431 5.20850219,33.2640127 7.09180128,32.5391577 C8.347334,32.0559211 11.4559176,30.0011079 16.4175519,26.3747182 C18.0338572,24.4997857 18.6973423,22.4544883 18.4080071,20.2388261 C17.963753,17.5346866 16.1776345,15.5799961 13.0496516,14.3747546 L10.9194936,13.4715819 L18.6192054,7.984237 L13.7918663,0.358365126 Z" id="path-1"></path>
                        <path d="M5.47320593,6.00457225 C4.05321814,8.216144 4.36334763,10.0722806 6.40359441,11.5729822 C8.61520715,12.571656 10.0999176,13.2171421 10.8577257,13.5094407 L15.5088241,14.433041 L18.6192054,7.984237 C15.5364148,3.11535317 13.9273018,0.573395879 13.7918663,0.358365126 C13.5790555,0.511491653 10.8061687,2.3935607 5.47320593,6.00457225 Z" id="path-3"></path>
                        <path d="M7.50063644,21.2294429 L12.3234468,23.3159332 C14.1688022,24.7579751 14.397098,26.4880487 13.008334,28.506154 C11.6195701,30.5242593 10.3099883,31.790241 9.07958868,32.3040991 C5.78142938,33.4346997 4.13234973,34 4.13234973,34 C4.13234973,34 2.75489982,33.0538207 2.37032616e-14,31.1614621 C-0.55822714,27.8186216 -0.55822714,26.0572515 -4.05231404e-15,25.8773518 C0.83734071,25.6075023 2.77988457,22.8248993 3.3049379,22.52991 C3.65497346,22.3332504 5.05353963,21.8997614 7.50063644,21.2294429 Z" id="path-4"></path>
                        <path d="M20.6,7.13333333 L25.6,13.8 C26.2627417,14.6836556 26.0836556,15.9372583 25.2,16.6 C24.8538077,16.8596443 24.4327404,17 24,17 L14,17 C12.8954305,17 12,16.1045695 12,15 C12,14.5672596 12.1403557,14.1461923 12.4,13.8 L17.4,7.13333333 C18.0627417,6.24967773 19.3163444,6.07059163 20.2,6.73333333 C20.3516113,6.84704183 20.4862915,6.981722 20.6,7.13333333 Z" id="path-5"></path>
                    </defs>
                    <g id="g-app-brand" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <g id="Brand-Logo" transform="translate(-27.000000, -15.000000)">
                            <g id="Icon" transform="translate(27.000000, 15.000000)">
                                <g id="Mask" transform="translate(0.000000, 8.000000)">
                                    <mask id="mask-2" fill="white">
                                        <use xlink:href="#path-1"></use>
                                    </mask>
                                    <use fill="#696cff" xlink:href="#path-1"></use>
                                    <g id="Path-3" mask="url(#mask-2)">
                                        <use fill="#696cff" xlink:href="#path-3"></use>
                                        <use fill-opacity="0.2" fill="#FFFFFF" xlink:href="#path-3"></use>
                                    </g>
                                    <g id="Path-4" mask="url(#mask-2)">
                                        <use fill="#696cff" xlink:href="#path-4"></use>
                                        <use fill-opacity="0.2" fill="#FFFFFF" xlink:href="#path-4"></use>
                                    </g>
                                </g>
                                <g id="Triangle" transform="translate(19.000000, 11.000000) rotate(-300.000000) translate(-19.000000, -11.000000) ">
                                    <use fill="#696cff" xlink:href="#path-5"></use>
                                    <use fill-opacity="0.2" fill="#FFFFFF" xlink:href="#path-5"></use>
                                </g>
                            </g>
                        </g>
                    </g>
                </svg>
            </span>
            <span class="app-brand-text demo menu-text fw-bolder ms-2">CENTER SCHOOL</span>
        </a>

        <a href="{{route('dashboard')}}" class="layout-menu-toggle menu-link text-large ms-auto d-block d-xl-none">
            <i class="bx bx-chevron-left bx-sm align-middle"></i>
        </a>
    </div>

    <div class="menu-inner-shadow"></div>

    <ul class="menu-inner py-1">
        <!-- Dashboard -->
        <li class="menu-item">
            <a href="{{route('dashboard')}}" class="menu-link">
                <i class="menu-icon tf-icons bx bx-home-circle"></i>
                <div data-i18n="Analytics">Dashboard</div>
            </a>
        </li>

        @if (Session::get('admin_page') == 'admin_user_view')
        @php $active = "active" @endphp
        @else
        @php $active = " " @endphp
        @endif

        @php
        $user_auth = \Illuminate\Support\Facades\Auth::user();
        @endphp
        @if($user_auth->admin_type == "Author User")
        <!-- Layouts -->
        <li class="menu-item {{$active}}">

            <a href="javascript:void(0);" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons bx bx-user"></i>
                <div data-i18n="Layouts">User Manage</div>
            </a>

            <ul class="menu-sub">
                <li class="menu-item">
                    <a href="{{ route('admin.user_all_view') }}" class="menu-link">
                        <div data-i18n="Without menu">View User</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.user_add_view') }}" class="menu-link">
                        <div data-i18n="Without navbar">Add User</div>
                    </a>
                </li>

            </ul>
        </li>


        <li class="menu-item {{$active}}">

            <a href="javascript:void(0);" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons bx bx-user"></i>
                <div data-i18n="Layouts">Premission @if($total>0) <span class="badge rounded-pill badge-notification bg-danger btn-sm">{{$total}}</span>
                    @else @endif</div>
            </a>

            <ul class="menu-sub">
                <li class="menu-item">
                    <a href="{{ route('admin.premission_dpt_result') }}" class="menu-link">
                        <div data-i18n="Without menu">Department Result @if($count>0)<span class="badge bg-danger badge-notification rounded-pill">{{$count}}</span> @else @endif</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.premission_gallery') }}" class="menu-link">
                        <div data-i18n="Without navbar">Gallery</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.user_add_view') }}" class="menu-link">
                        <div data-i18n="Without navbar">Videos</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.premission_notice') }}" class="menu-link">
                        <div data-i18n="Without navbar">Notice & Events @if($notice>0)<span class="badge bg-danger  badge-notification rounded-pill">{{$notice}}</span> @else @endif</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.premission_download') }}" class="menu-link">
                        <div data-i18n="Without menu">Download @if($download>0)<span class="badge bg-danger">{{$download}}</span> @else @endif</div>
                    </a>
                </li>

            </ul>
        </li>
        @endif
        <li class="menu-header small text-uppercase">
            <span class="menu-header-text">Setup</span>
        </li>
        @if (Session::get('admin_page') == 'admin_course_part_view')
        @php $active = "active" @endphp
        @else
        @php $active = " " @endphp
        @endif
        <li class="menu-item {{$active}}">
            <a href="javascript:void(0);" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons bx bx-dock-top"></i>
                <div data-i18n="Account Settings">Courses Setup</div>
            </a>
            <ul class="menu-sub">
                <li class="menu-item">
                    <a href="{{ route('admin.course_view') }}" class="menu-link">
                        <div data-i18n="Account">Courses View</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.course_part_view') }}" class="menu-link">
                        <div data-i18n="Account">Courses Part</div>
                    </a>
                </li>

            </ul>
        </li>

        <li class="menu-header small text-uppercase">
            <span class="menu-header-text">Pages Setting</span>
        </li>
        @if (Session::get('admin_page') == 'admin_download_view')
        @php $active = "active" @endphp
        @else
        @php $active = " " @endphp
        @endif
        <li class="menu-item {{$active}}">
            <a href="#" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons bx bx-cloud-download"></i>
                <div data-i18n="Authentications">Download Manage</div>
            </a>
            <ul class="menu-sub">
                <li class="menu-item">
                    <a href="{{ route('admin.download_all_add') }}" class="menu-link">
                        <div data-i18n="Basic">Download File Add</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.download_all_view') }}" class="menu-link">
                        <div data-i18n="Basic">Download File View</div>
                    </a>
                </li>

            </ul>
        </li>
        @if (Session::get('admin_page') == 'admin_dpt_result_view')
        @php $active = "active" @endphp
        @else
        @php $active = " " @endphp
        @endif
        <li class="menu-item {{$active}}">
            <a href="#" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons bx bx-download"></i>
                <div data-i18n="Authentications">Dept Result Manage</div>
            </a>
            <ul class="menu-sub">
                <li class="menu-item">
                    <a href="{{ route('admin.department_download_all_add') }}" class="menu-link">
                        <div data-i18n="Basic">Result File Add</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.department_download_all_view') }}" class="menu-link">
                        <div data-i18n="Basic">Result File View</div>
                    </a>
                </li>

            </ul>
        </li>
        @if (Session::get('admin_page') == 'admin_notice_view')
        @php $active = "active" @endphp
        @else
        @php $active = " " @endphp
        @endif
        <li class="menu-item {{$active}}">
            <a href="#" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons bx bx-cloud-download"></i>
                <div data-i18n="Authentications">Notice & Events</div>
            </a>
            <ul class="menu-sub">
                <li class="menu-item">
                    <a href="{{ route('admin.news_notice_view') }}" class="menu-link">
                        <div data-i18n="Basic">News & Notice View</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.event_view') }}" class="menu-link">
                        <div data-i18n="Basic">Events View</div>
                    </a>
                </li>

            </ul>
        </li>
        @if (Session::get('admin_page') == 'admin_entrance_view')
        @php $active = "active" @endphp
        @else
        @php $active = " " @endphp
        @endif
        <li class="menu-item {{$active}}">
            <a href="#" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons bx bx-layer-plus"></i>
                <div data-i18n="Authentications">Admission Entrance</div>
            </a>
            <ul class="menu-sub">
                <li class="menu-item">
                    <a href="{{ route('admin.entrance_view') }}" class="menu-link">
                        <div data-i18n="Basic">Entrance Info</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.entrance_process_view') }}" class="menu-link">
                        <div data-i18n="Basic">Entrance Process</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{route('admin.entrance_pdf_view')}}" class="menu-link">
                        <div data-i18n="Basic">Entrance Dcouments</div>
                    </a>
                </li>


            </ul>
        </li>
        @if (Session::get('admin_page') == 'admin_gallery_view')
        @php $active = "active" @endphp
        @else
        @php $active = " " @endphp
        @endif
        <li class="menu-item {{$active}}">
            <a href="javascript:void(0);" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons bx bx-images"></i>
                <div data-i18n="Account Settings">Gallery Manage</div>
            </a>
            <ul class="menu-sub">
                <li class="menu-item">
                    <a href="{{ route('admin.gallery_view') }}" class="menu-link">
                        <div data-i18n="Account">Gallery Photos </div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.video_view') }}" class="menu-link">
                        <div data-i18n="Account">Gallery Videos</div>
                    </a>
                </li>

            </ul>
        </li>
        @if (Session::get('admin_page') == 'admin_slider_view')
        @php $active = "active" @endphp
        @else
        @php $active = " " @endphp
        @endif


        @php
        $user_auth = \Illuminate\Support\Facades\Auth::user();
        @endphp
        @if($user_auth->admin_type == "Author User")
        <li class="menu-item {{$active}}">
            <a href="javascript:void(0);" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons bx bx-desktop"></i>
                <div data-i18n="Account Settings">Slider Manage</div>
            </a>
            <ul class="menu-sub">
                <li class="menu-item">
                    <a href="{{ route('admin.slider_view') }}" class="menu-link">
                        <div data-i18n="Account">Slider View</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.slider_add') }}" class="menu-link">
                        <div data-i18n="Notifications">slider Add</div>
                    </a>
                </li>
            </ul>
        </li>

        @endif
        @if (Session::get('admin_page') == 'admin_about_view')
        @php $active = "active" @endphp
        @else
        @php $active = " " @endphp
        @endif

        @php
        $user_auth = \Illuminate\Support\Facades\Auth::user();
        @endphp
        @if($user_auth->admin_type == "Author User")
        <li class="menu-item {{$active}}">
            <a href="#" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons bx bx-book-content"></i>
                <div data-i18n="Authentications">About Manage</div>
            </a>
            <ul class="menu-sub">
                <li class="menu-item">
                    <a href="{{ route('admin.about_update') }}" class="menu-link">
                        <div data-i18n="Basic">About Update</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.user_message_view') }}" class="menu-link">
                        <div data-i18n="Basic">User Message View</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.facultiesstaff_view') }}" class="menu-link">
                        <div data-i18n="Basic">Faculties and Staff</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{route('admin.Academics_view')}}" class="menu-link">
                        <div data-i18n="Basic">Academics</div>
                    </a>
                </li>

            </ul>
        </li>
        @endif
        @if (Session::get('admin_page') == 'admin_course_page_view')
        @php $active = "active" @endphp
        @else
        @php $active = " " @endphp
        @endif
        @php
        $user_auth = \Illuminate\Support\Facades\Auth::user();
        @endphp
        @if($user_auth->admin_type == "Author User")
        <li class="menu-item {{$active}}">
            <a href="#" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons bx bx-detail"></i>
                <div data-i18n="Authentications">Course Content</div>
            </a>
            <ul class="menu-sub">
                <li class="menu-item">
                    <a href="{{ route('admin.course_page_add') }}" class="menu-link">
                        <div data-i18n="Basic">Course Page Add</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.course_page_view') }}" class="menu-link">
                        <div data-i18n="Basic">Course Page View</div>
                    </a>
                </li>
            </ul>
        </li>
        @endif
        @if (Session::get('admin_page') == 'admin_dpt_message_view')
        @php $active = "active" @endphp
        @else
        @php $active = " " @endphp
        @endif
        @php
        $user_auth = \Illuminate\Support\Facades\Auth::user();
        @endphp
        @if($user_auth->admin_type == "Author User")
        <li class="menu-item {{$active}}">
            <a href="#" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons bx bx-message-rounded"></i>
                <div data-i18n="Authentications">Depts Message</div>
            </a>
            <ul class="menu-sub">
                <li class="menu-item">
                    <a href="{{ route('admin.user__department_add_view') }}" class="menu-link">
                        <div data-i18n="Basic">Message Add</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.user__department_view') }}" class="menu-link">
                        <div data-i18n="Basic">Message View</div>
                    </a>
                </li>
            </ul>
        </li>
        @endif

        @if (Session::get('admin_page') == 'admin_theme_view')
        @php $active = "active" @endphp
        @else
        @php $active = " " @endphp
        @endif
        @php
        $user_auth = \Illuminate\Support\Facades\Auth::user();
        @endphp
        @if($user_auth->admin_type == "Author User")
        <li class="menu-item {{$active}}">
            <a href="#" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons bx bx-receipt"></i>
                <div data-i18n="Authentications">Theme Manage</div>
            </a>
            <ul class="menu-sub">
                <li class="menu-item">
                    <a href="{{ route('admin.theme_update_view') }}" class="menu-link">
                        <div data-i18n="Basic">Theme Update View</div>
                    </a>
                </li>

            </ul>
        </li>
        @if (Session::get('admin_page') == 'admin_static_view')
        @php $active = "active" @endphp
        @else
        @php $active = " " @endphp
        @endif
        <li class="menu-item {{$active}}">
            <a href="#" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons bx bx-blanket"></i>
                <div data-i18n="Authentications">Static Manage</div>
            </a>
            <ul class="menu-sub">
                <li class="menu-item">
                    <a href="{{ route('admin.information_update_view') }}" class="menu-link">
                        <div data-i18n="Basic">Information View</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.testimonail_view') }}" class="menu-link">
                        <div data-i18n="Basic">Testimonials View</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.reason_all_view') }}" class="menu-link">
                        <div data-i18n="Basic">Reason View</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.admission_view') }}" class="menu-link">
                        <div data-i18n="Basic">Admission View</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.static_video') }}" class="menu-link">
                        <div data-i18n="Basic">Home One Videos</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.footer_quick_access') }}" class="menu-link">
                        <div data-i18n="Basic">Quick Access</div>
                    </a>
                </li>
            </ul>
        </li>
        @endif
        @if (Session::get('admin_page') == 'admin_footer_view')
        @php $active = "active" @endphp
        @else
        @php $active = " " @endphp
        @endif
        <li class="menu-item {{$active}}">
            <a href="#" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons bx bx-chevrons-down"></i>
                <div data-i18n="Authentications">Footer Manage</div>
            </a>
            <ul class="menu-sub">
                <li class="menu-item">
                    <a href="{{ route('admin.footer_resource_view') }}" class="menu-link">
                        <div data-i18n="Basic">Resources</div>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('admin.footer_quick_access') }}" class="menu-link">
                        <div data-i18n="Basic">Quick Access</div>
                    </a>
                </li>
            </ul>
        </li>
    </ul>
</aside>