@extends('admin.admin_master')
@section('admin.admin_content')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/css/jquery.dataTables.min.css"
        integrity="sha512-1k7mWiTNoyx2XtmI96o+hdjP8nn0f3Z2N4oF/9ZZRgijyV4omsKOXEnqL1gKQNPy2MTSP9rIEWGcH/CInulptA=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- ✅ load jQuery ✅ -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js"
        integrity="sha512-aVKKRRi/Q/YV+4mjoKBsE4x3H+BkegoM/em46NNlCqNTmUYADjBbeNefNxYV7giUp0VxICtqdrbqU7iVaeZNXA=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>


    <!-- ✅ load DataTables ✅ -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/js/jquery.dataTables.min.js"
        integrity="sha512-BkpSL20WETFylMrcirBahHfSnY++H2O1W+UnEEO4yNIl+jI2+zowyoGJpbtk6bx97fBXf++WJHSSK2MV4ghPcg=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <!-- Content -->
    <section>

        <div class="container-xxl flex-grow-1 container-p-y">
            <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> View Courses</h4>

            @php
                $i = 1;
            @endphp
            <!-- Basic Bootstrap Table -->
            <div class="card">
                <div class="row">
                    <div class="col-6 col">
                        <h5 class="card-header">List Courses</h5>

                    </div>
                    <div class="col-6 col card-header">
                        <a data-bs-toggle="modal" data-bs-target="#basicModal"
                            class="float-end btn btn-primary text-nowrap add-new-role text-white">Add New Course</a>
                    </div>
                </div>


                <div class="table-responsive text-nowrap pe-3 ps-3 pb-3">
                    <table class="table" id="exampleTable" width="100%">
                        <thead>
                            <tr class="text-nowrap">
                                <th>SN</th>
                                <th>Course Name</th>
                                <th>Affilitated By</th>
                                <th>Start Year</th>
                                <th>Course Duration</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">
                            @foreach ($course_view as $course)
                                <tr>
                                    <td>{{ $i++ }}</td>
                                    <td>{{ $course->course_name }}</td>
                                    <td>{{ $course->affilitated_by }}</td>
                                    <td>{{ $course->start_year }}</td>
                                    <td>{{ $course->course_duration }} Year</td>
                                    <td>@php
        $user_auth = \Illuminate\Support\Facades\Auth::user();
        @endphp
        @if($user_auth->admin_type == "Author User")
                                        <a data-bs-toggle="modal" data-bs-target="#basicModal{{ $course->id }}"
                                            class="btn btn-primary text-white">Edit</a> <a
                                            href="{{ route('admin.course_delete', $course->id) }}" id="deleteData"
                                            class="btn btn-danger">Delete</a>
                                            @else
                                <span class="text-danger">Action connot access</span>
                                @endif
                                        </td>
                                </tr>
                                <!-- Modal -->
                                <div class="modal fade" id="basicModal{{ $course->id }}" tabindex="-1"
                                    aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel1">Edit Course</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="Close"></button>
                                            </div>
                                            <form action="{{ route('admin.course_update', $course->id) }}" method="POST">
                                                @csrf
                                                <div class="modal-body">
                                                    <div class="row">
                                                        <div class="col mb-3">
                                                            <label for="nameBasic" class="form-label">Course Name</label>
                                                            <input type="text" id="course_name" class="form-control"
                                                                value="{{ $course->course_name }}" name="course_name"
                                                                placeholder="Diploma in IT" />
                                                            @error('course_name')
                                                                <p class="text-danger">{{ $message }}</p>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                    <div class="row g-2">
                                                        <div class="col mb-0">
                                                            <label for="emailBasic" class="form-label">Course
                                                                Duration</label>
                                                            <input type="text" id="course_duration" class="form-control"
                                                                name="course_duration"
                                                                value="{{ $course->course_duration }}" placeholder="3" />
                                                            @error('course_duration')
                                                                <p class="text-danger">{{ $message }}</p>
                                                            @enderror
                                                        </div>
                                                        <div class="col mb-0">
                                                            <label for="dobBasic" class="form-label">Affilitated By</label>
                                                            <input type="text" id="affilitated_by" class="form-control"
                                                                name="affilitated_by" placeholder="CTEVT"
                                                                value="{{ $course->affilitated_by }}" />
                                                            @error('affilitated_by')
                                                                <p class="text-danger">{{ $message }}</p>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                    <div class="row g-2 mt-3">
                                                        <div class="col mb-0">
                                                            <label for="emailBasic" class="form-label">Start Year</label>
                                                            <input type="text" id="start_year" name="start_year"
                                                                value="{{ $course->start_year }}" class="form-control"
                                                                placeholder="2020" />
                                                            @error('start_year')
                                                                <p class="text-danger">{{ $message }}</p>
                                                            @enderror
                                                        </div>

                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-outline-secondary"
                                                        data-bs-dismiss="modal">
                                                        Close
                                                    </button>
                                                    <button type="submit" class="btn btn-primary">Update</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <!--/ Basic Bootstrap Table -->
        </div>
        <!-- / Content -->

        <!-- Modal -->
        <div class="modal fade" id="basicModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel1">Add New Course</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="{{ route('admin.course_store') }}" method="POST">
                        @csrf
                        <div class="modal-body">
                            <div class="row">
                                <div class="col mb-3">
                                    <label for="nameBasic" class="form-label">Course Name</label>
                                    <input type="text" id="course_name" class="form-control title_count" name="course_name"
                                        placeholder="Diploma in IT" />
                                    @error('course_name')
                                        <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                    <span class="characterCount" style="font-size: 12px;"></span> <span style="font-size: 12px;">Enter Only 100 Characters </span>
                                </div>
                            </div>
                            <div class="row g-2">
                                <div class="col mb-0">
                                    <label for="emailBasic" class="form-label">Course Duration</label>
                                    <input type="text" id="course_duration" class="form-control"
                                        name="course_duration" placeholder="3" />
                                    @error('course_duration')
                                        <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                </div>
                                <div class="col mb-0">
                                    <label for="dobBasic" class="form-label">Affilitated By</label>
                                    <input type="text" id="affilitated_by" class="form-control" name="affilitated_by"
                                        placeholder="CTEVT" />
                                    @error('affilitated_by')
                                        <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                            <div class="row g-2 mt-3">
                                <div class="col mb-0">
                                    <label for="emailBasic" class="form-label">Start Year</label>
                                    <input type="text" id="start_year" name="start_year" class="form-control"
                                        placeholder="2020" />
                                    @error('start_year')
                                        <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                </div>

                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                                Close
                            </button>
                            <button type="submit" class="btn btn-primary">Save changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>


    </section>
    <script>
        $(document).ready(function() {
            $.noConflict();
            $('#exampleTable').DataTable();
        });
    </script>
@endsection
