@extends('admin.admin_master')
@section('admin.admin_content')
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> Create New Entrance</h4>

    <div class="row">
        <div class="col-md-12">

            <div class="card mb-4">
                <div class="row">
                    <div class="col-6 col">
                        <h5 class="card-header">Add Entrance</h5>

                    </div>
                    <div class="col-6 col card-header">
                        <a href="{{ route('admin.entrance_view') }}" class="float-end btn btn-primary text-nowrap add-new-role">View All Entrance</a>
                    </div>
                </div>
                <!-- Account -->
                <hr class="my-0" />
                <div class="card-body">
                    <form id="formAccountSettings" method="POST" action="{{ route('admin.entrance_store') }}" enctype="multipart/form-data">
                        @csrf


                        <div class="mb-3 col-md-12">
                            <label for="title" class="form-label">Entrance Title <span class="text-danger">*</span></label>
                            <input type="text" name="title" id="title" placeholder="Admission Title" class="form-control title_count">
                            @error('title')
                            <p class="text-danger">{{ $message }}</p>
                            @enderror
                            <span class="characterCount" style="font-size: 12px;"></span> <span style="font-size: 12px;">Enter Only 100 Characters </span>
                        </div>

                        <div class="mb-3 col-md-12">
                            <label for="file" class="form-label">Description <span class="text-danger">*</span></label>
                            <textarea class="form-control ckeditor" id="file" name="para" rows="15" placeholder="Admission Description "></textarea>
                            @error('para')
                            <p class="text-danger">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="mt-2 float-end">
                            <button type="submit" class="btn btn-primary me-2">Add Entrance</button>
                            <button type="reset" class="btn btn-outline-secondary">Cancel</button>
                        </div>
                </div>

                </form>
            </div>
            <!-- /Account -->
        </div>

    </div>
    <!-- / Content -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            $('.ckeditor').ckeditor();
        });
    </script>
 
 
    @endsection