@extends('admin.admin_master')
@section('admin.admin_content')
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> Create Events Notice</h4>

    <div class="row">
        <div class="col-md-12">

            <div class="card mb-4">
                <div class="row">
                    <div class="col-6 col">
                        <h5 class="card-header">Add Events Notice</h5>

                    </div>
                    <div class="col-6 col card-header">
                        <a href="{{ route('admin.event_view') }}" class="float-end btn btn-primary text-nowrap add-new-role">View All Events Notice</a>
                    </div>
                </div>
                <!-- Account -->
                <hr class="my-0" />
                <div class="card-body">
                    <form id="formAccountSettings" method="POST" action="{{ route('admin.event_update',$event_edit->id) }}" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <h5 class="fw-bold py-3 mb-3">Events Notice Information</h5>
                            <div class="mb-3 col-md-12">
                                <label for="notice_title" class="form-label">Events Notice Title <span class="text-danger">*</span></label>
                                <input type="text" name="event_title" id="event_title" value="{{$event_edit->event_title}}" class="form-control count_title" placeholder="Graduation/Farewell Program">

                                @error('event_title')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                                <span class="characterCount" style="font-size: 12px;"></span> <span style="font-size: 12px;">Enter Only 100 Characters </span>

                            </div>
                            <div class="mb-3 col-md-12">
                                <label for="notice_title" class="form-label">Events Time <span class="text-danger">*</span></label>
                                <input type="text" name="event_time" id="event_time" value="{{$event_edit->event_time}}" class="form-control" placeholder="8:00AM - 6:00PM">

                                @error('event_time')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="mb-3 col-md-12">
                                <label for="notice_title" class="form-label">Events Date <span class="text-danger">*</span></label>
                                <input type="date" name="event_date" id="event_date" value="{{$event_edit->event_date}}" class="form-control" placeholder="01/20/2023">

                                @error('event_date')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="mb-3 col-md-12">
                                <label for="notice_title" class="form-label">Events Place <span class="text-danger">*</span></label>
                                <input type="text" name="location" id="location"  value="{{$event_edit->location}}" class="form-control" placeholder="Ma.Vi. Center School">
                                @error('location')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                           
                            
                            <div class="container">
                            <div class="mt-2 float-end">
                                <button type="submit" class="btn btn-primary me-2">Update Events</button>
                                <button type="reset" class="btn btn-outline-secondary">Cancel</button>
                            </div>
                            </div>
                        </div>

                    </form>
                </div>
                <!-- /Account -->
            </div>
        </div>
    </div>
    @php
$multiple_event = \App\Models\EventImage::where('event_id', $event_edit->id)->get();
@endphp
<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="row">
                <div class="col-6 col">
                    <h5 class="card-header">Multi Event Edit</h5>
                </div>
            </div>
            <div class="box-body">
                <form action="{{route('admin.event_image_update')}}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="row row-sm">
                        @foreach ($multiple_event as $items)
                        <div class="col-md-3">
                            <div class="card">

                                <div class="card-body">
                                    <img class="card-img-top" src=" {{ asset($items->image) }}" alt="Card image cap" height="130px" width="280px">
                                    <div class="card-title">
                                        <a href="{{route('admin.event_image_delete',$items->id)}}" class="btn btn-danger mt-2" id="deleteData"><i class="bi bi-trash"></i></a>
                                    </div>
                                    <div class="card-text">
                                        <div class="form-group">
                                            <label class="form-control-label">Change Event <span class="text-danger">*</span></label>
                                            <input type="file" name="image[{{ $items->id }}]" id="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach

                    </div>
                    <div class="container">
                        <div class="col-12 mt-3 text-end">
                            <button type="submit" class="btn btn-primary">Update Event Notice</button>
                        </div>
                    </div>
                </form>
            </div>

        </div>
    </div>

</div>
</div>
<!-- / Content -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

<script>
    $(document).ready(function() {
        $('#multiImg').on('change', function() { //on file input change
            if (window.File && window.FileReader && window.FileList && window.Blob) //check File API supported browser
            {
                var data = $(this)[0].files; //this file data

                $.each(data, function(index, file) { //loop though each file
                    if (/(\.|\/)(gif|jpe?g|png)$/i.test(file.type)) { //check supported file type
                        var fRead = new FileReader(); //new filereader
                        fRead.onload = (function(file) { //trigger function on successful read
                            return function(e) {
                                var img = $('<img/>').addClass('thumb').attr('src', e.target.result).width(80)
                                    .height(80); //create image element 
                                $('#preview_img').append(img); //append image to output element
                            };
                        })(file);
                        fRead.readAsDataURL(file); //URL representing the file's data.
                    }
                });

            } else {
                alert("Your browser doesn't support File API!"); //if File API is absent
            }
        });
    });
</script>
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $('.ckeditor').ckeditor();
    });
</script>

@endsection