@extends('admin.admin_master')
@section('admin.admin_content')
<div class="container-xxl flex-grow-1 container-p-y">


<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="row">
                <div class="col-6 col">
                    <h5 class="card-header">Multi Event Edit</h5>
                </div>
                <div class="col-6 col text-end">
                    <h5 class="card-header"><a href="{{ route('admin.gallery_view') }}" class="btn btn-primary">View All</a></h5>
                </div>
            </div> 
            <div class="box-body">
                <form action="{{route('admin.gallery_image_update')}}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="row row-sm">
                        @foreach ($gallery_details as $items)
                        <div class="col-md-3 mt-3">
                            <div class="card">
                                <div class="card-body ">
                                    <img class="card-img-top" src="{{ asset($items->image) }}" alt="Card image cap" height="130px" width="280px">
                                    <div class="card-title">
                                        <a href="{{route('admin.gallery_image_delete',$items->id)}}" class="btn btn-danger mt-2" id="deleteData"><i class="bi bi-trash"></i></a>
                                    </div>
                                    <div class="card-text">
                                        <div class="form-group">
                                            <label class="form-control-label">Change Event <span class="text-danger">*</span></label>
                                            <input type="file" name="image[{{ $items->id }}]" id="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach

                    </div>
                    <div class="container">
                        <div class="col-12 mt-3 text-end">
                            <button type="submit" class="btn btn-primary">Update Image</button>
                        </div>
                    </div>
                </form>
            </div>

        </div>
    </div>

</div>
</div>
<!-- / Content -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

<script>
    $(document).ready(function() {
        $('#multiImg').on('change', function() { //on file input change
            if (window.File && window.FileReader && window.FileList && window.Blob) //check File API supported browser
            {
                var data = $(this)[0].files; //this file data

                $.each(data, function(index, file) { //loop though each file
                    if (/(\.|\/)(gif|jpe?g|png)$/i.test(file.type)) { //check supported file type
                        var fRead = new FileReader(); //new filereader
                        fRead.onload = (function(file) { //trigger function on successful read
                            return function(e) {
                                var img = $('<img/>').addClass('thumb').attr('src', e.target.result).width(80)
                                    .height(80); //create image element 
                                $('#preview_img').append(img); //append image to output element
                            };
                        })(file);
                        fRead.readAsDataURL(file); //URL representing the file's data.
                    }
                });

            } else {
                alert("Your browser doesn't support File API!"); //if File API is absent
            }
        });
    });
</script>
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $('.ckeditor').ckeditor();
    });
</script>

@endsection