@extends('admin.admin_master')
@section('admin.admin_content')
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/css/jquery.dataTables.min.css" integrity="sha512-1k7mWiTNoyx2XtmI96o+hdjP8nn0f3Z2N4oF/9ZZRgijyV4omsKOXEnqL1gKQNPy2MTSP9rIEWGcH/CInulptA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<!-- ✅ load jQuery ✅ -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js" integrity="sha512-aVKKRRi/Q/YV+4mjoKBsE4x3H+BkegoM/em46NNlCqNTmUYADjBbeNefNxYV7giUp0VxICtqdrbqU7iVaeZNXA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>


<!-- ✅ load DataTables ✅ -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/js/jquery.dataTables.min.js" integrity="sha512-BkpSL20WETFylMrcirBahHfSnY++H2O1W+UnEEO4yNIl+jI2+zowyoGJpbtk6bx97fBXf++WJHSSK2MV4ghPcg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<!-- Content -->

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> View Sliders</h4>

    @php
    $i = 1;
    @endphp
    <!-- Basic Bootstrap Table -->
    <div class="card">
        <div class="row">
            <div class="col-6 col">
                <h5 class="card-header">List Sliders</h5>

            </div>
            <div class="col-6 col card-header">
                <a href="{{ route('admin.slider_add') }}" class="float-end btn btn-primary text-nowrap add-new-role text-white">Add New Slider</a>
            </div>
        </div>


        <div class="table-responsive text-nowrap pe-3 ps-3 pb-3">
            <table class="table" id="exampleTable" width="100%">
                <thead>
                    <tr class="text-nowrap">
                        <th>SN</th>
                        <th>Slider Image</th>
                        <th>Slider Heading</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody class="table-border-bottom-0">
                    @foreach ($slider_view as $slider)
                    <tr>
                        <td>{{ $i++ }}</td>
                        <td><img src="{{ asset($slider->image) }}" height="20px" alt=""></td>
                        <td>{{ $slider->slider_heading }}</td>
                        @if ($slider->status == 1)
                        <td><span class="badge bg-success text-capitalize rounded-pill">Active</span></td>
                        @else
                        <td><span class="badge bg-danger text-capitalize rounded-pill">Inactive</span></td>
                        @endif

                        <td><a href="{{ route('admin.slider_edit', $slider->id) }}" class="btn btn-primary btn-sm"><i class="bi bi-pencil"></i></a>
                            <a href="{{ route('admin.slider_delete', $slider->id) }}" id="deleteData" class="btn btn-primary btn-sm"><i class="bi bi-trash"></i></a>
                            <a data-bs-toggle="modal" data-bs-target="#pricingModal{{ $slider->id }}" class="btn btn-primary btn-sm text-white"><i class="bi bi-eye"></i></a>

                            @if ($slider->status == 1)
                            <a href="{{ route('admin.slider_view.active', $slider->id) }}" class="btn btn-sm btn-danger"><i class="bi bi-arrow-down"></i></a>
                            @else
                            <a href="{{ route('admin.slider_view.inactive', $slider->id) }}" class="btn btn-sm btn-success"><i class="bi bi-arrow-up"></i></a>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <!--/ Basic Bootstrap Table -->
</div>
<!-- / Content -->

<script>
    $(document).ready(function() {
        $.noConflict();
        $('#exampleTable').DataTable();
    });
</script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script>
    $(function() {
        $(document).on('click', '#deleteData', function(e) {
            e.preventDefault();
            var link = $(this).attr("href");

            Swal.fire({
                title: 'Are You Sure?',
                text: "Are You Sure Delete This Data!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = link
                    Swal.fire(
                        'Deleted!',
                        'Your File has been Deleted.',
                        'success'
                    )
                }
            })
        })
    })
</script>
@endsection