@extends('user.user_master')
@section('user.user_content')
@php
$images = \App\Models\Theme::find(1);
@endphp
@section('user_title')
Entrance Application - Entrance Application Information
@endsection
<section id="hero" class="hero">
    <div class="hero-container mb-lg-0">
        <div id="heroCarousel">

            <div class="carousel-inner" role="listbox">
                <!-------Slide First------->
                <div class="carousel-item-application active">
                    <div class="carousel-background"><img class="" style="height:100vh!important; width: 100vw; background-size: cover;" src="https://images.pexels.com/photos/1438072/pexels-photo-1438072.jpeg" alt="">
                    </div>
                    <div class="carousel-container">
                        <div class="carousel-content container">
                            <div class="container" style="text-align: start!important;">
                                <div class="row align-items-center justify-content-center">
                                    <div class="col-lg-6 col-md-12 pl-lg-0">
                                        <div class="slider_text">
                                            <h2>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans(' Admission Open 2080', 'ne') }} @else Admission Open 2080 @endif</h2>
                                        </div>

                                        <div class="row clearfix">
                                            <div class="col-lg-12 col-md-12 col-sm-12">
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-lg-6 col-md-12 carousel-content-items">
                                        <div class="row">
                                            <div class="col-12 pt-0 pb-2 sub-t  itle">
                                                <h5> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Eligibility Criteria', 'ne') }} @else Eligibility Criteria @endif</h5>
                                            </div>
                                            @foreach($entrance as $item)
                                            <div class="col-12 col-md-12 col-lg-6 px-0">
                                                <div class="content-box heighted mr-lg-2">
                                                    <div class="content-box-title">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($item->title, 'ne') }} @else {{$item->title}} @endif</div>
                                                    <ul>
                                                    @if(session()->get('language') == 'nepali') {!! \Stichoza\GoogleTranslate\GoogleTranslate::trans($item->para, 'ne') !!} @else    {!! $item->para !!} @endif
                                                     

                                                    </ul>
                                                </div>
                                            </div>
                                            @endforeach

                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Projects Start -->
<section class="section-admission mt-5 mb-5 ">
    <div class="container">
        <div class="row">
            <div class="col-lg-7 text-start bg-white col-md-12 col-sm-12 col-12">
                <div id="accordion" class="accordion">
                    @foreach($info as $item)
                    <div class="card">
                        <div class="card-header" id="headingOne{{$item->id}}">
                            <h5 class="mb-0">
                                <button class="btn btn-link" data-toggle="collapse" data-target="#collapseOne{{$item->id}}" aria-expanded="true" aria-controls="collapseOne">
                                @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($item->title, 'ne') }} @else {{$item->title}} @endif 
                                </button>
                            </h5>
                        </div>

                        <div id="collapseOne{{$item->id}}" class="collapse show" aria-labelledby="headingOne{{$item->id}}" data-parent="#accordion">
                            <div class="card-body">
                                <div class="p-2">
                                    <div style="font-family: 'Barlow', sans-serif;
                                        font-size: 15px;
                                        color: #585858;">
                                   @if(session()->get('language') == 'nepali') {!! \Stichoza\GoogleTranslate\GoogleTranslate::trans($item->para, 'ne') !!} @else    {!! $item->para !!} @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                    
                </div>
            </div>
            <div class="col-md-1"></div>
            <div class="col-lg-4 text-self-end bg-white col-md-12 col-sm-12 col-12 mt-4 mt-lg-0">
                <div class="content-single admission">
                    <div class="tab-content">
                        <div class="tab-pane fade show active shadow bg-white" id="tab-short-bio" role="tabpanel" aria-labelledby="tab-short-bio">
                            <table class="table table-striped" style="font-family: 'Barlow', sans-serif;
                                font-weight: 500;
                                font-size: 15px;">
                                <thead>
                                    <tr>
                                        <td class="bg-primary text-white"> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Download', 'ne') }} @else Download @endif</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($pdf as $item)
                                    <tr>
                                        <td><a href="{{route('user.application_pdf',$item->id)}}"> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($item->title, 'ne') }} @else {{$item->title}} @endif</a></td>
                                    </tr>
                                    @endforeach
                                </tbody>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>



@endsection