@extends('user.user_master')
@section('user.user_content')
@php
$images = \App\Models\Theme::find(1);
@endphp
@section('user_title')
Course - {{$course_details->course->course_name}}
@endsection
<section>
    <!-- Page Content -->
    <div class="page-heading header-text" style="background-image: url('{{asset($images->image)}}');">
        <div class="container page-opacity">
            <div class="row">
                <div class="col-md-12">
                    <h1>@if(session()->get('language') == 'nepali') {!! \Stichoza\GoogleTranslate\GoogleTranslate::trans($course_details->course->course_name, 'ne') !!} @else {{$course_details->course->course_name}}  @endif</h1>
                    <span>We have over 20 years of experience</span>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="program-offer">
    <div class="container course pt-5 heading">
        <h2 class="h1-responsive font-weight-bold text-start my-1 mb-4 text-capitalize">
             @if(session()->get('language') == 'nepali') {!! \Stichoza\GoogleTranslate\GoogleTranslate::trans($course_details->course->course_name, 'ne') !!} @else {{$course_details->course->course_name}}   @endif
        </h2>
        <!--Section description-->
    </div>
</section>
<!-------Info Section start------->
<section class="section-box-2 course-details-nav mt-5 mb-5">
    <div class="container">
        <div class="box-nav-tabs mb-3">
            <ul class="nav" role="tablist">
                <li><a class="btn border aboutus-icon active me-3" href="#tab-short-bio" data-bs-toggle="tab" role="tab" aria-controls="tab-short-bio" aria-selected="true">Overview</a></li>
                <li><a class="btn border recruitment-icon me-3" href="#tab-skills" data-bs-toggle="tab" role="tab" aria-controls="tab-skills" aria-selected="false">Curriculum</a></li>

            </ul>
        </div>
        <div class="border-bottom pt-10 pb-10"></div>
    </div>
</section>
<section class="section-box mt-5 mb-5 ">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 bg-white col-md-12 col-sm-12 col-12">
                <div class="content-single">
                    <div class="tab-content">
                        <div class="tab-pane fade show active border bg-white p-4" id="tab-short-bio" role="tabpanel" aria-labelledby="tab-short-bio">
                            <h4>@if(session()->get('language') == 'nepali') {!! \Stichoza\GoogleTranslate\GoogleTranslate::trans($course_details->course->course_name, 'ne') !!} @else {{$course_details->course->course_name}} @endif</h4>
                            <p>   @if(session()->get('language') == 'nepali') {!! \Stichoza\GoogleTranslate\GoogleTranslate::trans($course_details->course_description , 'ne') !!} @else {!! $course_details->course_description !!}  @endif</p>

                        </div>
                        <div class="tab-pane fade border p-4" id="tab-skills" role="tabpanel" aria-labelledby="tab-skills">
                            <div class="accordion accordion-flush" id="accordionFlushExample">
                                @php
                                $semester = \App\Models\CoursePart::where('course_id',$course_details->course_id)->get();
                                @endphp
                                @foreach($semester as $semester_item)
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="flush-headingOne">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne{{$semester_item->id}}" aria-expanded="false" aria-controls="flush-collapseOne">
                                             @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($semester_item->course_part, 'ne') }} @else {{$semester_item->course_part}} @endif
                                        </button>
                                    </h2>
                                    @php
                                    $semester_subject = \App\Models\CourseSubject::where('course_part_id',$semester_item->id)->get();
                                    @endphp
                                    <div id="flush-collapseOne{{$semester_item->id}}" class="accordion-collapse collapse" aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample">
                                        <div class="accordion-body">
                                            <table class="table">
                                                <thead>
                                                    <tr>
                                                        <th scope="col">SN</th>
                                                        <th scope="col">Course Code</th>
                                                        <th scope="col">Course Name</th>
                                                        <th scope="col">Credit Hour</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($semester_subject as $key=>$semester_subjects)
                                                    <tr>
                                                        <td scope="row">{{$key+1}}</th>
                                                        <td>{{$semester_subjects->subject_code}}</td>
                                                        <td>{{$semester_subjects->subject_name}}</td>
                                                        <td>{{$semester_subjects->subject_hours}}</td>
                                                    </tr>
                                                    @endforeach
                                                  
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                @endforeach

                            </div>
                        </div>

                    </div>
                </div>

            </div>

        </div>
    </div>
</section>
@endsection