@extends('user.user_master')
@section('user.user_content')

@php
$course = \App\Models\CoursePage::orderBy('id','DESC')->get();
$user_message = \App\Models\Message::orderBy("id",'ASC')->get();

$images = \App\Models\Theme::find(1);

@endphp
@section('user_title')
Course - Programs Offered
@endsection
<section>
    <!-- Page Content -->
    <div class="page-heading header-text" style="background-image: url('{{asset($images->image)}}');">
        <div class="container page-opacity">
            <div class="row">
                <div class="col-md-12">
                    <h1>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($departements_message->course->course_name, 'ne') }} @else {{$departements_message->course->course_name}} @endif</h1>
                    <span>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Intelligence plus character – that is the goal of true education.', 'ne') }} @else Intelligence plus character – that is the goal of true education. @endif</span>
                </div>
            </div>
        </div>
    </div>
</section>


<section class="section-department mt-5 mb-5 ">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 col-12 col-xl-8 col-md-8">
                <div class="border p-3 bg-white rounded">
                    <p>@if(session()->get('language') == 'nepali') {!! \Stichoza\GoogleTranslate\GoogleTranslate::trans($departements_message->des, 'ne') !!} @else {!! $departements_message->des !!} @endif</p>
                    <section class="program-offer">
                        <div class="container course  heading">
                            <h2 class="h1-responsive font-weight-bold text-start my-1  text-capitalize">
                                @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans(' HOD Message ', 'ne') }} @else HOD Message @endif</h2>
                            <!--Section description-->
                        </div>
                    </section>

                    <hr>
                    <div class="about-section pt-2 pb-5">
                        <div class="">
                            <div class="row">
                                <div class="col-md-12 right-info">

                                    <div class="row">

                                        <div class="col-md-3 mt-1">
                                            <img src="{{asset($departements_message->image)}}" class="img-fluid rounded-circle" style="border:1px solid #075e89; float: left;" alt="Image Empty">
                                        </div>
                                        <div class="col-md-9" height="270">
                                            <p> @if(session()->get('language') == 'nepali') {!! \Stichoza\GoogleTranslate\GoogleTranslate::trans( $departements_message->dept_message, 'ne') !!} @else {!! $departements_message->dept_message !!} @endif</p>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4 col-12 col-xl-4 mt-lg-none mt-3 mt-lg-0">
                <div class="border p-2 rounded bg-white notice">
                    <div id="carouselExampleSlidesOnly" class="carousel slide" data-bs-ride="carousel">
                        <div class="carousel-inner">
                            @foreach($user_message as $user)
                            <div class="carousel-item {{$user->user->id == 6 ?"active":""}}">
                                <div class="">
                                    <div class="box-radius-8 bg-9 hover-up">
                                        <div class="image">
                                            <figure><img class="mx-auto d-block" src="{{(!empty($user->user->profile_photo_path))?url($user->user->profile_photo_path):url('./uploads/default_images/no_image.jpg')}}" width="150px" class="img-fluid" alt="jobBox"></figure>
                                        </div>
                                        <div class="text-info text-center">
                                            <h3 style="color:#585858!important;">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Mr.'. $user->user->name, 'ne')  }} @else Mr {{$user->user->name}} @endif </h3>
                                            <h6 class="" style="color:#585858!important;">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($user->user->user_post, 'ne')  }} @else {{$user->user->user_post}} @endif</h6>
                                            <h6 style="color:#585858!important;">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($user->user->phone, 'ne')  }} @else {{$user->user->phone}} @endif</h6>
                                            <div class="mt-15"><a class="read-more" href="{{url('/message-view',$user->id.'/'.$user->message_heading)}}">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Read Message ', 'ne')  }} @else Read Message @endif<i class="bi bi-arrow-right-circle-fill"></i></a></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection