@extends('user.user_master')
@section('user.user_content')
@php
$course = \App\Models\CoursePage::orderBy('id', 'DESC')->get();
@endphp
@section('user_title')
Download - File Download
@endsection
@php
$images = \App\Models\Theme::find(1);
@endphp

<section>
    <!-- Page Content -->
    <div class="page-heading header-text" style="background-image: url('{{asset($images->image)}}');">
        <div class="container page-opacity">
            <div class="row">
                <div class="col-md-12">
                    <h1>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Downloads', 'ne')  }} @else Downloads @endif</h1>
                    <span>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Education is not preparation for life; education is life itself.', 'ne')  }} @else Education is not preparation for life; education is life itself. @endif</span>
                </div>
            </div>
        </div>
    </div>
</section>


<section class="section-department mt-5 mb-5 ">
    <div class="intro">
        <div class="bg-image h-100">
            <div class="mask d-flex align-items-center">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-12 col-lg-12">
                            <div class="card">
                                <div class="card-body p-0">
                                    <div class="table-responsive" data-mdb-perfect-scrollbar="true" style="position: relative;">
                                        <table class="table table-striped mb-0" id="exampleTable" width="100%">

                                            <thead>
                                                <tr>
                                                    <th colspan="5" class="bg-primary">
                                                        <p class="bg-primary p-2" style=" margin-bottom: -1px;">
                                                        @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('  Recent Downloads', 'ne')  }} @else   Recent Downloads @endif
                                                      </p>
                                                    </th>
                                                </tr>
                                                <tr>
                                                    <th scope="col"> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Published Date', 'ne')  }} @else Published Date @endif</th>
                                                    <th scope="col"> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('File Title', 'ne')  }} @else File Title @endif</th>
                                                    <th scope="col">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Files', 'ne')  }} @else Files @endif</th>
                                                    <th scope="col">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Published By', 'ne')  }} @else Published By @endif</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($downloads as $download)
                                                <tr>
                                                    <td>@php
                                                        $year = $download->created_at->format('Y');
                                                        $month = $download->created_at->format('m');
                                                        $day = $download->created_at->format('d');
                                                        $date = Bsdate::eng_to_nep($year, $month, $day);
                                                        echo $date['nmonth'] . ' ' . $date['date'] .','. ' ' . $date['year'];
                                                        @endphp</td>
                                                    <td><a href="{{url('download-details',$download->id.'/'.$download->title)}}">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($download->title, 'ne')  }} @else  {{$download->title}}  @endif</a></td>
                                                    @php
                                                    $download_file = \App\Models\DownloadFile::where('download_id',$download->id)->get();
                                                    @endphp
                                                    <td>
                                                        @foreach($download_file as $item) <a href="{{route('user.download_file_view',$item->id)}}"><i class="bi bi-file-earmark-pdf-fill"></i></a>@endforeach</td>
                                                    <td> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($download->user->name, 'ne')  }} @else  {{$download->user->name}} @endif</td>
                                                </tr>
                                                @endforeach


                                            </tbody>
                                        </table>
                                      
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12">
                                            <nav aria-label="Page navigation example" class="mt-5 mb-5">
                                                <ul class="pagination justify-content-center" style="font-family: 'Titillium Web', sans-serif;">
                                                    <div style="box-shadow: 0px 4px 4px 4px rgb(231, 230, 230);display: flex;">
                                                        {{$downloads->links()}}
                                                    </div>
                                                </ul>
                                            </nav>
                                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@endsection