@extends('user.user_master')
@section('user.user_content')
@php
$course = \App\Models\CoursePage::orderBy('id', 'DESC')->get();
@endphp
@section('user_title')
Events - Event Lists
@endsection
@php
$images = \App\Models\Theme::find(1);
@endphp
<section class="mb-4">
        <!-- Page Content -->
        <div class="page-heading header-text" style="background-image: url('{{asset($images->image)}}');">
            <div class="container page-opacity">
                <div class="row">
                    <div class="col-md-12">
                        <h1>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Events', 'ne')  }} @else Events @endif</h1>
                        <span>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Self-education is, I firmly believe, the only kind of education there is.', 'ne')  }} @else Self-education is, I firmly believe, the only kind of education there is. @endif</span>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Projects Start -->
    <section>
        <div class="container-xxl mb-5 mt-5">
            <div class="container">


                <div class="row portfolio-container">

                    <div class="row mt-4 mt-md-5 pxp-animate-in pxp-animate-in-top">
                        @foreach($events as $event)
                        <div class="col-md-12 pxp-jobs-card-1-container mb-4">
                            <div class="row pxp-jobs-card-1 border p-3 rounded">
                                <div class="col-md-2">
                                    @php
                                    $new_date = date('jS', strtotime($event->event_date));
                                    $month = date('m Y', strtotime($event->event_date));
                                    @endphp
                                    <h1>{{$new_date}}</h1>
                                    <p>{{$month}}</p>
                                </div>
                                <div class="col-md-10">
                                    <div class="pxp-jobs-card-1-top">
                                        <div class="pxp-jobs-card-1-details mt-2">
                                            <a href="jobs-list-1.html">
                                                <h5> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($event->event_title, 'ne')  }} @else {{$event->event_title}} @endif </h5>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="row bottom-items">
                                    <div class="col-2"></div>
                                    <div class="col-md-10">
                                        <div class="text-start" style="margin-bottom: -23px!important;">
                                            <span class=" mt-4"> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($event->location, 'ne')  }} @else {{$event->location}} @endif </span>
                                        </div>
                                        <div class="text-end">
                                            <span class="text-end mt-4">@php
                                                        $year = $event->created_at->format('Y');
                                                        $month = $event->created_at->format('m');
                                                        $day = $event->created_at->format('d');
                                                        $date = Bsdate::eng_to_nep($year, $month, $day);
                                                        echo $date['nmonth'] . ' ' . $date['date'] .','. ' ' . $date['year'];
                                                        @endphp</span>
                                        </div>
                                      
                                        
                                    </div>
                                </div>
                            </div>
                           
                        </div>
                        @endforeach
                    </div>
                </div>
                <div class="col-lg-12 col-md-12 col-sm-12">
                    <nav aria-label="Page navigation example" class="mt-5 mb-5">
                        <ul class="pagination justify-content-center" style="font-family: 'Titillium Web', sans-serif;">
                            <div style="box-shadow: 0px 4px 4px 4px rgb(231, 230, 230);display: flex;">
                               {{$events->links()}}
                            </div>

                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </section>
    <!-- Projects End -->

@endsection