@extends('user.user_master')
@section('user.user_content')
@php
$images = \App\Models\Theme::find(1);
@endphp
<section>
        <!-- Page Content -->
        <div class="page-heading header-text" style="background-image: url('{{asset($images->image)}}');">
            <div class="container page-opacity">
                <div class="row">
                    <div class="col-md-12">
                        <h1>Facilites</h1>
                        <span>Education is the key to unlocking the world, a passport to freedom.</span>
                    </div>
                </div>
            </div>
        </div>
    </section>
      <!-------Info Section start------->
      <section class="why-choose pt-5 bg-light pb-5">
        <div class="container heading">
            <div class="row pb-5">
              
            @foreach($facilities as $facilitie)
            <div class="col-lg-4 col-md-6 col-sm-6">
                <div class="card-offer hover-up border p-3">
                    <div class="card-image"><img class="img-fluid" width="100px" src="{{asset($facilitie->icon)}}" alt="iori"></div>
                    <div class="card-info">
                        <h4 class="color-brand-1 mb-15"> @if(session()->get('language') == 'nepali') {!! \Stichoza\GoogleTranslate\GoogleTranslate::trans($facilitie->reason_name, 'ne') !!} @else {{$facilitie->reason_name}} @endif</h4>
                        <p>
                            @if(session()->get('language') == 'nepali') {!! \Stichoza\GoogleTranslate\GoogleTranslate::trans(\Illuminate\Support\Str::limit($facilitie->short_des, 150), 'ne') !!} @else {!! \Illuminate\Support\Str::limit($facilitie->short_des, 150) !!} @endif
                        </p>
                        <a class="read-more" href="{{url('facilitates-details',$facilitie->id.'/'.$facilitie->reason_name_slug)}}">@if(session()->get('language') == 'nepali') {!! \Stichoza\GoogleTranslate\GoogleTranslate::trans('Read More', 'ne') !!} @else Read More @endif <i class="bi bi-arrow-right-circle-fill"></i></a>
                    </div>
                </div>
            </div>
            @endforeach 
            </div>
        </div>
    </section>

@endsection